<?php

namespace App\Events;

use App\Models\JobApplication;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class JobStatusUpdated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $jobApplication;
    public $oldStatus;
    public $newStatus;

    public function __construct(JobApplication $jobApplication, $oldStatus, $newStatus)
    {
        $this->jobApplication = $jobApplication;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
    }
}
